package com.ejie.ab04b.evento;

import java.io.Serializable;
import java.util.Map;

/**
 * Objeto que se crea a partir de la informacion de un evento leido de la cola
 * de avisos
 * 
 * @author GFI-NORTE
 * 
 */
public class EventoAvisos implements Serializable {

	private static final long serialVersionUID = 1L;

	private String eventWhat; // en que consiste el evento
	private String eventWho; // quien genera el evento
	private String eventTipology; // tipologia del evento
	private String plateaType;
	private String plateaSubType;
	private String status;
	private String mailbox;
	private Map<String, String> datosEvento; // mapa con los datos del evento

	/**
	 * Instantiates a new evento avisos.
	 * 
	 *  eventWhat            String
	 *  eventWho            String
	 *  eventTipology            String
	 *  plateaType            String
	 *  plateaSubType            String
	 *  status            String
	 *  mailbox            String
	 *
	 * @param eventWhat the event what
	 * @param eventWho the event who
	 * @param eventTipology the event tipology
	 * @param plateaType the platea type
	 * @param plateaSubType the platea sub type
	 * @param status the status
	 * @param mailbox the mailbox
	 */
	public EventoAvisos(String eventWhat, String eventWho, String eventTipology,
			String plateaType, String plateaSubType, String status,
			String mailbox) {
		this.eventWhat = eventWhat;
		this.eventWho = eventWho;
		this.eventTipology = eventTipology;
		this.plateaType = plateaType;
		this.plateaSubType = plateaSubType;
		this.status = status;
		this.mailbox = mailbox;
	}

	/**
	 * Gets the event what.
	 * 
	 *  String
	 *
	 * @return the event what
	 */
	public String getEventWhat() {
		return this.eventWhat;
	}

	/**
	 * Sets the event what.
	 * 
	 *  eventWhat            String
	 *
	 * @param eventWhat the new event what
	 */
	public void setEventWhat(String eventWhat) {
		this.eventWhat = eventWhat;
	}

	/**
	 * Gets the event who.
	 * 
	 *  String
	 *
	 * @return the event who
	 */
	public String getEventWho() {
		return this.eventWho;
	}

	/**
	 * Sets the event who.
	 * 
	 *  eventWho            String
	 *
	 * @param eventWho the new event who
	 */
	public void setEventWho(String eventWho) {
		this.eventWho = eventWho;
	}

	/**
	 * Gets the event tipology.
	 * 
	 *  String
	 *
	 * @return the event tipology
	 */
	public String getEventTipology() {
		return this.eventTipology;
	}

	/**
	 * Sets the event tipology.
	 * 
	 *  eventTipology            String
	 *
	 * @param eventTipology the new event tipology
	 */
	public void setEventTipology(String eventTipology) {
		this.eventTipology = eventTipology;
	}

	/**
	 * Gets the platea type.
	 * 
	 *  String
	 *
	 * @return the platea type
	 */
	public String getPlateaType() {
		return this.plateaType;
	}

	/**
	 * Sets the platea type.
	 * 
	 *  plateaType            String
	 *
	 * @param plateaType the new platea type
	 */
	public void setPlateaType(String plateaType) {
		this.plateaType = plateaType;
	}

	/**
	 * Gets the platea sub type.
	 * 
	 *  String
	 *
	 * @return the platea sub type
	 */
	public String getPlateaSubType() {
		return this.plateaSubType;
	}

	/**
	 * Sets the platea sub type.
	 * 
	 *  plateaSubType            String
	 *
	 * @param plateaSubType the new platea sub type
	 */
	public void setPlateaSubType(String plateaSubType) {
		this.plateaSubType = plateaSubType;
	}

	/**
	 * Gets the status.
	 * 
	 *  String
	 *
	 * @return the status
	 */
	public String getStatus() {
		return this.status;
	}

	/**
	 * Sets the status.
	 * 
	 *  status            String
	 *
	 * @param status the new status
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	/**
	 * Gets the mailbox.
	 * 
	 *  String
	 *
	 * @return the mailbox
	 */
	public String getMailbox() {
		return this.mailbox;
	}

	/**
	 * Sets the mailbox.
	 * 
	 *  mailbox            String
	 *
	 * @param mailbox the new mailbox
	 */
	public void setMailbox(String mailbox) {
		this.mailbox = mailbox;
	}

	/**
	 * Gets the datos evento.
	 * 
	 *  Map<String, String>
	 *
	 * @return the datos evento
	 */
	public Map<String, String> getDatosEvento() {
		return this.datosEvento;
	}

	/**
	 * Sets the datos evento.
	 * 
	 *  datosEvento            Map<String, String>
	 *
	 * @param datosEvento the datos evento
	 */
	public void setDatosEvento(Map<String, String> datosEvento) {
		this.datosEvento = datosEvento;
	}

	/**
	 * Obtiene, si existe, el valor del dato identificado por nombreDato Si no
	 * existe devuelve null.
	 * 
	 *  nombreDato            String
	 *  String
	 *
	 * @param nombreDato the nombre dato
	 * @return the dato
	 */
	public String getDato(String nombreDato) {
		String valor = null;

		if (this.datosEvento != null && !this.datosEvento.isEmpty()
				&& this.datosEvento.keySet().contains(nombreDato)) {
			valor = this.datosEvento.get(nombreDato);
		}

		return valor;
	}
}
